package gov.va.med.mhv.usermgmt.data.repository;

import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.query.Procedure;
import org.springframework.data.repository.query.Param;

import gov.va.med.mhv.common.data.model.Patient;

public interface PatientRepository extends JpaRepository<Patient, Long> {

	@Query("select patient from Patient patient where patient.userProfile.id = :userProfileid")
	public List<Patient> getPatientByUserProfileId(@Param("userProfileid") Long userProfileid);

	@Query("select patient from Patient patient where patient.icn = :icn")
	public List<Patient> getPatientByIcn(@Param("icn") String icn);

	@Query("select patient from Patient patient where lower(patient.icn) = :icn")
	public List<Patient> getPatientByPartialIcn(@Param("icn") String icn);

	@Query("select p from Patient p, UserProfile u "+
		   "where u.lastName not like 'DELETED' "+
		   "and u.lastName not like 'DECEASED' "+
		   "and p.matchedDateTime is not null "+
		   "and (p.correlationStatus = 0 or p.correlationStatus = 7)")
	public List<Patient> getMatchedUncorrelatedPatients();

	@Query("select p from Patient p, UserProfile u "+
		   "where ((u.firstName is null "+
		   "or u.lastName is null "+
			"or u.birthDate is null "+
			"or u.ssn is null "+
			"or u.gender is null) or "+
			"(u.firstName ='' "+
			"or u.lastName ='' "+
			"or u.birthDate ='' "+
			"or u.ssn ='' "+
			"or u.gender = '')) "+
			"and u.addressCountry is not null "+
			"and u.addressCountry != 'Korea, South' "+
			"and u.addressCountry != 'Virgin Islands, British' "+
			"and u.lastName not like '%DELETED' "+
			"and u.lastName not like '%Deleted' "+
			"and u.lastName not like '%DECEASED' "+
			"and u.lastName not like '%Deceased' "+
			"and p.userProfileId = u.id")
	public List<Patient> getRequiredFieldsNotEmpty();

	@Query("select p from Patient p, UserProfile u "+
			"where (u.firstName is not null "+
			"or u.lastName is not null "+
			"or u.birthDate is not null "+
			"or u.ssn is not null "+
			"or u.gender is not null) "+
			"and (u.isVeteran = 1 or u.isPatient = 1) "+
			"and u.addressCountry is not null "+
			"and u.addressCountry != 'Korea, South' "+
			"and u.addressCountry != 'Virgin Islands, British' "+
			"and p.matchedDateTime is null "+
			"and u.lastName not like '%DELETED' "+
			"and u.lastName not like '%Deleted' "+
			"and u.lastName not like '%DECEASED' "+
			"and u.lastName not like '%Deceased' "+
			"and u.id between :firstRow and :lastRow "+
			"and p.userProfileId = u.id")
	public List<Patient> getRecordsNotMatchedToMVI(@Param("firstRow") long firstRow, @Param("lastRow") long lastRow);

	@Query("select p from Patient p, UserProfile u where  "+
    	  "p.icn is not null "+
    		"and u.addressCountry is not null "+
    		"and u.addressCountry != 'Korea, South' "+
			"and u.addressCountry != 'Virgin Islands, British' "+
    		"and u.id between :firstRow and :lastRow "+
    		"and u.lastName not like '%DELETED' "+
			"and u.lastName not like '%Deleted' "+
			"and u.lastName not like '%DECEASED' "+
			"and u.lastName not like '%Deceased' "+
    		"and (u.isVeteran = 1 or u.isPatient = 1)")
	public List<Patient> getRecordsMHVMVIMisMatch(@Param("firstRow") long firstRow, @Param("lastRow") long lastRow);
	
	@Procedure("MHV_VAR_ELIGIBILITY")
	 public int varEligibleCheck(Long patientid);
	
	@Query("select p from Patient p, UserProfile u where " +
			"p.icn is not null " +
			"and p.icn like '%V%' " +
			"and (u.createdDate is not null or u.lastLogin is not null) " +
			"and u.lastName not like '%DECEASED' " +
			"and u.lastName not like '%Deceased' " +
			"and u.lastName not like '%DELETED%' " +
			"and u.lastName not like '%Deleted%' " +
			"and u.deactivationDateTime is null " +
			"and p.userProfileId = u.id")
	public List<Patient> getAutoDeactivationList();
	
	@Query("select p from Patient p, UserProfile u where " +
			"p.icn is not null " +
			"and p.icn like '%V%' " +
			"and p.userProfileId = 10508892" +
			"and p.userProfileId = 10532936" +
			"and p.userProfileId = 10565182" +
			"and p.userProfileId = 10533117" +
			"and p.userProfileId = 10526288" +
			"and p.userProfileId = 10719279" +
			"and p.userProfileId = 10719291" +
			"and p.userProfileId = 10719287" +
			"and u.lastName not like '%DELETED%' " +
			"and u.lastName not like '%Deleted%' " +
			"and u.deactivationDateTime is null " +
			"and p.userProfileId = u.id")
	public List<Patient> getAutoDeactivationListTest();
	
	@Query("select p from Patient p, UserProfile u where " +
			"p.userProfileId = u.id " +
			"and u.lastName like :lastName")
	public List<Patient> getAutoDeactivationListLastName(@Param("lastName") String lastName);
	
	@Query("select p from Patient p, UserProfile u "
			+ "where p.userProfileId = u.id "
			+ "and (SYSDATE - :daysSinceCreation) > u.createdDate "
			+ "and upper(u.lastName) not like '%DELETED' "
			+ "and u.deactivationDateTime is null")  // TODO: Look at this and see if it's correct to include this parameter
	public Page<Patient> getPatientListCreatedBefore(@Param("daysSinceCreation")int daysSinceCreation, Pageable pageRequest);
	
	//@Query("select s.emailAddress from SMS_SRE.SMSUSER s where " +
	//		"s.ssn = :ssn")
	//public String getAutoDeactivationListSMSUser(@Param("SSN") String ssn);
	
}